unit MediaPlayer_unit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, MPlayer, StdCtrls;

type
  TForm2 = class(TForm)
    MediaPlayer1: TMediaPlayer;
    btOpen: TButton;
    btStop: TButton;
    procedure btOpenClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure MediaPlayer1PostClick(Sender: TObject;
      Button: TMPBtnType);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: MediaPlayer
// Class: MPlayer.TMediaPlayer
// Property: MPlayer.TMediaPlayer.FileName
// Method: MPlayer.TMediaPlayer.Open
// Method: MPlayer.TMediaPlayer.Play
// Property: MPlayer.TMediaPlayer.AutoEnable
// Property: MPlayer.TMediaPlayer.EnabledButtons

// BeginCode
{
This example demonstrates the use of TMediaPlayer component. Assuming 2 buttons
for Open and Stop are present on the form.
Note: AutoEnable must be set to false to be able to control
the buttons manually.
}

procedure TForm2.btOpenClick(Sender: TObject);
var
  OpenMediaDialog : TOpenDialog;
begin
  OpenMediaDialog := TOpenDialog.Create(Self);
  OpenMediaDialog.Filter := 'All Video Files (*.avi)|*.avi';
  // There are avi files in
  // C:\Documents and Settings\All Users\Documents\RAD Studio\6.0\Demos\DelphiWin32\VCLWin32\CoolStuff
  if OpenMediaDialog.Execute() then
  begin
    { Assign a file to the media player }
    MediaPlayer1.FileName := OpenMediaDialog.FileName;

    { Check if the file exists and is not a directory }
    if (FileExists(OpenMediaDialog.FileName)) and
       (not DirectoryExists(OpenMediaDialog.FileName)) then
    begin
      { Open the files }
      MediaPlayer1.Wait := true;
      MediaPlayer1.Open;
      MediaPlayer1.Play;

      { Override automatic button controlling }
      MediaPlayer1.EnabledButtons :=
        [TMPBtnType.btPause, TMPBtnType.btStop, TMPBtnType.btPlay];

      { Enable  the stop button }
      btStop.Enabled := true;
      btOpen.Enabled := false;
    end;
  end;

  OpenMediaDialog.Free;
end;

procedure TForm2.btStopClick(Sender: TObject);
begin
  { Stop and close the media }
  MediaPlayer1.Stop;
  MediaPlayer1.Close;

  MediaPlayer1.EnabledButtons := [];

  { Enable open button again }
  btOpen.Enabled := true;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  { Disable all buttons }
  MediaPlayer1.AutoEnable := false;
  MediaPlayer1.EnabledButtons := [];
end;

procedure TForm2.MediaPlayer1PostClick(Sender: TObject;
  Button: TMPBtnType);
begin
  if Button = TMPBtnType.btStop then
     btStop.Click;
end;

// EndCode
// EndExample: MediaPlayer

end.
