{
GetMemoryManager, SetMemoryManager example
The following example implements a memory manager that 
counts the number of times the GetMem, FreeMem, and 
ReallocMem entry points are called. You must call the 
SetNewMemMgr routine to install the new memory manager. 
The new memory manager routines simply passes on the 
requests to the previous memory manager after 
incrementing the appropriate counter.
} 
var
  GetMemCount: Integer;
  FreeMemCount: Integer;
  ReallocMemCount: Integer;
  OldMemMgr: TMemoryManager;

function NewGetMem(Size: Integer): Pointer;
begin
  Inc(GetMemCount);
  Result := OldMemMgr.GetMem(Size);
end;

function NewFreeMem(P: Pointer): Integer;
begin
  Inc(FreeMemCount);
  Result := OldMemMgr.FreeMem(P);
end;

function NewReallocMem(P: Pointer; Size: Integer): Pointer;
begin
  Inc(ReallocMemCount);
  Result := OldMemMgr.ReallocMem(P, Size);
end;

const
  NewMemMgr: TMemoryManager = (
  GetMem: NewGetMem;
  FreeMem: NewFreeMem;
  ReallocMem: NewReallocMem);

procedure SetNewMemMgr;
begin
  GetMemoryManager(OldMemMgr);
  SetMemoryManager(NewMemMgr);
end; 
