unit MyMoveRects;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Memo1: TMemo;
    CheckBox1: TCheckBox;
    ListBox1: TListBox;
    ComboBox1: TComboBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  Rects = ^TRect;
  RectList = array[0..10] of TRect;

var
  Form1: TForm1;
  myRects: Rects;
  myRectList : RectList;
  procedure ListRect(Rect: TRect);
  procedure ListRects(PRects: Rects; Count: Integer);
  procedure ReadRects;
  procedure WriteRects;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ListRects(myRects, Form1.ComponentCount);
end;

procedure ListRect(Rect: TRect);
begin
  Form1.ListBox1.Items.Add(
    'BoundsRect: Left: ' + IntToStr(Rect.Left) +
    ' Right: ' + IntToStr(Rect.Right) +
    ' Top: ' + IntToStr(Rect.Top) +
    ' Bottom: ' + IntToStr(Rect.Bottom));
end;

{$IFDEF UNICODE}
{$POINTERMATH ON}
procedure ListRects(PRects: Rects; Count: Integer);
begin
  while Count > 0 do
  begin
    ListRect(PRects[Count - 1]); // This line will not compile without Tiburon.
//    ListRect((PRects + Count - 1)^); // Neither will this line.
    Dec(Count);
  end;
end;
{$ELSE}
procedure ListRects(PRects: Rects; Count: Integer);
begin
  Form1.ListBox1.Items.Add(
    'This is a Tiburon example and does nothing in Highlander');
end;
{$ENDIF}

procedure ReadRects;
var
  I, index : Integer;
  Temp: TWinControl;
begin
{$T-}
  index := 0;
  for I := Form1.ComponentCount - 1 downto 0 do
  begin
    if (Form1.Components[I] is TWinControl) then
    begin
      Temp := TWinControl(Form1.Components[I]);
      myRectList[index] := Temp.BoundsRect;
      index := index + 1;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  myRects := Addr(myRectList);
  ReadRects;
end;

procedure WriteRects;
var
  I, index : Integer;
  Temp: TWinControl;
begin
{$T-}
  index := 0;
  for I := Form1.ComponentCount - 1 downto 0 do
  begin
    if (Form1.Components[I] is TWinControl) then
    begin
      Temp := TWinControl(Form1.Components[I]);
      Temp.BoundsRect := myRectList[index];
      index := index + 1;
    end;
  end;
end;

end.
