unit OnActivate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    CustomerDS: TDataSource;
    BlobDS: TDataSource;
    procedure FormCreate(Sender: TObject);
    procedure ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

// BeginExample: OnActivate
// Event: Forms.TCustomForm.OnActivate
// Property: Classes.TComponent.ComponentCount
// Property: Classes.TComponent.Components

// BeginCode
{
This example fills a list box with the names of TDataSources
that are present and then fills a DBGrid a second form with 
the data from the selected data source.  The DBGrid is not 
filled in until Form2 is activated.  Here is the code for Form1
that fills the list box.
}
var
  Form1: TForm1;
  Customers: TTable;
  Blobs: TTable;
  Form1Done : Boolean;
  procedure CreateMyTable;
  procedure CreateCustSource;
  procedure CreateBlobSource;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
begin
  CreateCustSource;
  CreateBlobSource;
  for I := 0 to ComponentCount - 1 do
  begin
    if (Components[I] is TDataSource) then
      ListBox1.Items.AddObject(Components[I].Name,
        Components[I] as TObject);
  end;
end;

procedure CreateCustSource();
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'MyCustInfo';
    ReadOnly:= False;

//    Don't overwrite an existing table
//    Looking for c:/ProgramFiles/Common Files/Codegear Shared/Data/dbdemos.gdb
    if (not Customers.Exists) then CreateMyTable
    else
    begin
      if (Customers.Exists AND
        (MessageDlg('MyCustInfo table already exists.  Do you want to rebuild it?', mtConfirmation, [mbYes, mbNo], 0) = mrYes)) then
      begin
        Customers.Close;
        Customers.DeleteTable;
        CreateMyTable;
      end;
    end;
  end;
  Form1.CustomerDS.DataSet:= Customers;
  Customers.Active:= True;
end;

procedure CreateMyTable();
var
  i: Integer;
begin
//      The Table component must not be active
//      First, describe the type of table and give
//      it a name
//      Next, describe the fields in the table
  with Customers do
  begin
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
        with AddFieldDef do
        begin
          Name := 'Field3';
          DataType := ftString;
          Size := 30;
        end;
        with AddFieldDef do
        begin
          Name := 'Field4';
          DataType := ftString;
          Size := 30;
        end;
      end;

//    Take out this part to remove indexing
//    Next, describe any indexes
      with IndexDefs do
      begin
        Clear;
//        The 1st index has no name because it is
//        a Paradox primary key
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;

//      Call the CreateTable method to create the table
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 20 do
        Customers.AppendRecord([i*111, i*222, i*333, i*444]);
    end;
end;

procedure CreateBlobSource;
var
  i: Integer;
begin
  Blobs:= TTable.Create(Form1);
  with Blobs do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'MyBlobInfo';
    Blobs.Active := False;
    { Don't overwrite an existing table }
//    if Blobs.Exists then
//      MessageDlg('CustInfo table already exists.', mtWarning, [mbOK], 0)
//    else
    begin
      if (Blobs.Exists) then
      begin
        Blobs.Close;
        Blobs.DeleteTable;
      end;
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftBlob;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
{
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
}
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Blobs.Active:= True;
      for i := 1 to 20 do
        Blobs.AppendRecord([i*111, IntToStr(i*222)]);
    end;
  end;
  Form1.BlobDS.DataSet:= Blobs;
  Blobs.Active:= True;
end;

procedure TForm1.ListBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Form1Done := True;
end;

initialization

Form1Done := False;
// EndCode
// EndExample: OnActivate
end.
