{
OnActivate, ComponentCount, Components example
The following code sets the DataSource for a DBGrid component in Form2 to the currently selected data source in a list provided in Form1. This allows users to specify the desired information in Form1, and then move to Form2 to view the information.
} 
procedure TForm2.FormActivate(Sender: TObject);
begin
  DBGrid1.DataSource := 
    Form1.ListBox1.Objects[Form1.ListBox1.ItemIndex] as TDataSource;
end;
{
Here is the code on Form1 that fills the list box:
} 
procedure TForm1.FormCreate(Sender.TObject);
var
  I: Integer;
begin
  for I := 0 to DataModule2.ComponentCount - 1 do
  begin
    if (DataModule2.Components[I] is TDataSource) then
      ListBox1.Items.AddObject(DataModule2.Components[I].Name,
        DataModule2.Components[I] as TObject);
  end;
end; 
