
(*
 Delphi Object and Component Reference
# {bmc bm10.BMP} OnActiveControlChange, Focused example
This example uses the OnActiveControlChange event to detect when focus changes on the form. When focus changes, the hint for the active control is displayed on the status bar. To use this example, you must add a status bar to the form and set its SimplePanel property to true.
{bmc bm15.BMP}	This example can be adapted for an application using Windows-only components. Simply replace the object name TWidgetControl with its Windows-only counterpart, TWinControl.
Add a new public procedure, ActiveControlChanged, to the TForm1 class declaration:
*) 
type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Memo1: TMemo;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure ActiveControlChanged(Sender: TObject);
  end;
Implement this procedure as follows:
*) 
procedure TForm1.ActiveControlChanged(Sender: TObject);
var
  Active : TWinControl;
  I: Integer;
begin
  Active := Controls[0];
  for I:= 0 to ControlCount -1 do
  begin
    if Controls[I] is TWinWidgetControl then
      if (Controls[I] as TWinWidgetControl).Focused then
        Active := Controls[I];
  end;
  if Active <> nil then
    StatusBar1.SimpleText = GetLongHint(Active.Hint);
end;
Assign this method as the OnActiveControlChange event handler by setting it from the form's OnCreate event handler:
*) 
procedure TForm1.FormCreate(Sender: TObject);
begin
  Screen.OnActiveControlChange := ActiveControlChanged;
end;
Make sure you clean up the screen object when the form is freed by adding this OnDestroy event handler to the form:
*) 
procedure TForm1.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveControlChange := nil;
end; 
