unit OnActiveFormChange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

// BeginExample: OnActiveFormChange
// Property: Forms.TScreen.ActiveForm
// Event: Forms.TScreen.OnActiveFormChange

// BeginCode
{
This example uses a two forms with a button on the first
form. When the user clicks the button, the second form
appears. As the user switches between forms, the form that
is active is colored aqua.
Note:	You must include the unit header for form 2 to the
unit file for form 1, and add the public ColorForm method
to the header for form 1s unit.
}
type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    procedure ColorForm(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses Unit2;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
end;

procedure TForm1.ColorForm(Sender: TObject);
begin
  Color := clWhite;
  Form2.Color := clWhite;
  Screen.ActiveForm.Color := clAqua;
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
  Screen.OnActiveFormChange := ColorForm;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  // This stops ColorForm from being called during termination.
  Screen.OnActiveFormChange := nil;
end;
// EndCode
// EndExample: OnActiveFormChange
end.
