unit OnCloseQuery;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnCloseQuery
// Event: Forms.TCustomForm.OnCloseQuery

// BeginCode
{
When the user attempts to close the form in this example, a
message dialog appears that asks the user if it is OK to
close the form. If the user chooses the OK button, the form
closes. If the user chooses Cancel, the form doesn't close.
Populate the OnCloseQuery event handler of the form.
}
procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if MessageDlg('Close the form?', mtConfirmation,
    [mbOk, mbCancel], 0) = mrCancel then
     CanClose := False;
end;
// EndCode
// EndExample: OnCloseQuery
end.
