{
OnDragOver, OnDragDrop example
This code comes from an application that contains a list box and three labels, each with a different font and color.  The DragMode property for each of the labels is dmAutomatic.  The user can select a label and drag it to a list box and drop it. When the label is dropped, the items in the list box assume the color and font of the dropped label. 
This OnDragOver event handler permits the list box to accept a dropped label:
} 
procedure TForm1.ListBox1DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := Source is TLabel;
end;
This OnDragDrop event handler implements the drop behavior.
*) 
procedure TForm1.ListBox1DragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  if (Sender is TListBox) and (Source is TLabel) then
  begin
    with Sender as TListBox do
    begin
      Font := (Source as TLabel).Font;
      Color := (Source as TLabel).Color;
    end;
  end;
end; 
