{
OnDrawItem, Canvas example
Here is a typical handler for an OnDrawItem event. In the example, a list box with the lbOwnerDrawFixed style draws a bitmap to the left of each string.
}
procedure TForm1.ListBox1DrawItem(Control: TWinControl; Index: Integer; Rect:TRect; State: TOwnerDrawState);
var
  Bitmap: TBitmap;      { temporary variable for the items bitmap }
  Offset: Integer;      { text offset width }
begin
with (Control as TListBox).Canvas do  { draw on control canvas, not on the form }
begin
  FillRect(Rect);       { clear the rectangle }
  Offset := 2;          { provide default offset }
  Bitmap := TBitmap((Control as TListBox).Items.Objects[Index]);  { get the bitmap }
  if Bitmap <> nil then
  begin
    BrushCopy(Bounds(Rect.Left + Offset, Rect.Top, Bitmap.Width, Bitmap.Height),
    Bitmap, Bounds(0, 0, Bitmap.Width, Bitmap.Height), clRed);  {render bitmap}
    Offset := Bitmap.width + 6;    { add four pixels between bitmap and text}
  end;
  TextOut(Rect.Left + Offset, Rect.Top, (Control as TListBox).Items[Index])  { display the text }
end;

end;

