unit OnDrawPanel;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, ComCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    ImageList1: TImageList;
    procedure StatusBar1DrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnDrawPanel

// Event: ComCtrls.TStatusBar.OnDrawPanel
// Event: ComCtrls.TCustomStatusBar.OnDrawPanel
// Property: ComCtrls.TCustomStatusBar.Canvas
// Property: ComCtrls.TCustomStatusBar.Panels
// Method: ImgList.TCustomImageList.Draw
// Property: ComCtrls.TStatusPanel.Style

// BeginCode
{
The following code is the OnDrawPanel event handler of a
status bar.  It draws each panel of the status bar, adding
text and icons stored in ImageList1. The image list contains
as many icons as there are header sections.  This example
requires a populated image list and a statusbar with several
panels added to the Panels property.  Select each panel and
set the Style property to psOwnerDraw.
}
procedure TForm1.StatusBar1DrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
begin
with StatusBar1.Canvas do
  begin
    Brush.Color := clRed;
    FillRect(Rect);
    Font.Color := clYellow;
    ImageList1.Draw(StatusBar1.Canvas,Rect.Left,Rect.Top,Panel.Index);
    TextOut(Rect.left + 30, Rect.top + 2, 'Panel' + IntToStr(Panel.Index));
  end;
end;
// EndCode
// EndExample: OnDrawPanel
end.
