unit OnDropDown;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Unit2, Unit3;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    Button1: TButton;
    Button2: TButton;
    procedure ComboBox1DropDown(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnDropDown
// Event: StdCtrls.TCustomCombo.OnDropDown
// Property: StdCtrls.TCustomComboBox.Sorted
// Method: Classes.TStrings.Clear
// Method: Classes.TStrings.BeginUpdate
// Method: Classes.TStrings.EndUpdate

// BeginCode
{
This example fills the list of a combo box with the set of
open forms when the user drops down the list. The list is
regenerated every time the list is dropped down, so if the
application opens or closes forms, the combo box stays current.
}
procedure TForm1.ComboBox1DropDown(Sender: TObject);
var
  I: Integer;
begin
  with ComboBox1 do
  begin
    Items.BeginUpdate; { prevent repaints until done }
    Items.Clear; { empty the list of any old values }
    for I := 0 to Screen.CustomFormCount - 1 do
    begin
      if (Screen.CustomForms[I].Visible) then
        Items.Add(Screen.CustomForms[I].Caption); { add form name }
    end;
    Items.EndUpdate; {reenable painting }
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox1.Sorted := True; { make sure the form names are sorted }
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Form3.Show;
end;
// EndCode
// EndExample: OnDropDown
end.
