{
OnDropDown, Sorted, Clear, BeginUpdate, EndUpdate example
This example fills the list of a combo box with the set of open forms when the user drops down the list. The list is regenerated every time the list is dropped down, so if the application opens or closes forms, the combo box stays current.
} 
procedure Form1.ComboBox1DropDown(Sender: TObject);
var
  I: Integer;
begin
  with ComboBox1 do 
  begin
    Items.BeginUpdate; { prevent repaints until done }
    Items.Clear; { empty the list of any old values }
    Sorted := True; { make sure the form names are sorted }
    for I := 0 to Screen.CustomFormCount  1 do
    begin
      Items.Add(Screen.CustomForms[I].Caption); { add form name }
    end;
    Items.EndUpdate; {reenable painting }
  end;
end; 
