unit OnGetEditMask;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    procedure StringGrid1GetEditMask(Sender: TObject; ACol, ARow: Integer;
      var Value: string);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnGetEditMask
// Method: Grids.TCustomDrawGrid.OnGetEditMask

// BeginCode
{
This example specifies an edit mask in a string grid to
limit the cells that contain telephone numbers, as indicated
by a label cell in the first row.  Include goEditing in the
TStringGrid Options property.  Set the title of one of the
columns to 'Phone Number'.  Set the DefaultColWidth large
enough to see a phone number.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  StringGrid1.Cells[2, 0]:= 'Phone Number';
end;

procedure TForm1.StringGrid1GetEditMask(Sender: TObject; ACol, ARow: Longint; var Value: string);
begin
  if StringGrid1.Cells[ACol, 0] = 'Phone Number' then
    Value :=  '!\(999\)000-0000;1';
end;
// EndCode
// EndExample: OnGetEditMask
end.
