unit OnMessage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure AppMessage(var Msg: TMsg; var Handled: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnMessage
// Event: Forms.TApplication.OnMessage

// BeginCode
{
The following code handles a custom message that the
application sends to itself when a file is ready for reading.
}
const WM_FILEREADY = WM_USER + 2000;
procedure TForm1.Button1Click(Sender: TObject);
const Path: PChar = 'OverView.RTF';
begin
  PostMessage(Application.Handle, WM_FILEREADY, 0, integer(Path));
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnMessage := AppMessage;
end;

procedure TForm1.AppMessage(var Msg: TMsg; var Handled: Boolean);
var msgStr: String;
begin
  if Msg.hwnd = Application.Handle then
  begin
    if Msg.message = WM_FILEREADY then
    begin
      msgStr:= PChar(Msg.lParam);
      Memo1.Lines.LoadFromFile(msgStr);
      Handled := True;
    end;
  end;
  { for all other messages, Handled remains False }
  { so that other message handlers can respond }
end;
// EndCode
// EndExample: OnMessage
end.
