{
The following code handles a custom message that the application sends to itself 
when a file is ready for reading.
} 
const
 WM_FILEREADY = WM_USER + 2000;
procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.OnMessage := AppMessage;
end;

procedure TForm1.AppMessage(var Msg: TMsg; var Handled: Boolean);
begin
  if Msg.message = WM_FILEREADY then
  begin
    Memo1.Lines.LoadFromFile(StrPas(PChar(Msg.lParam)));
    Handled := True;
  end;
  { for all other messages, Handled remains False }
  { so that other message handlers can respond }
end; 
