{
OnMoved example
This example uses a splitter and two image controls to create a "slide show" effect.
The example displays an image (the current "slide"), which can be hidden behind a 
screen that looks like a venetian blind. When the blind is pulled down to 
completely cover the current slide, the slide changes to a different image.  When 
the blind is raised, the new image appears.
To prepare this example, follow these steps:
1. Place an image control on the form.  
Set the picture property to a bitmap of a venetian blind, 
Set the Stretch property to True.
Set the Align property to alTop. 
2. Add a splitter control to the form.
Set the Align property to alTop.
Set the Cursor property to crVSplit.
Set the OnMoved event handler to the code that appears below.
Set the MinSize property to 1.
3. Add a second image control to the form.
Set the Align property to alClient.
Set the Stretch property to True.
4. Select the form and add the OnCreate and OnDestroy event handlers that appear below.
5. Add the global variables below to the unit.
} 
var
  CurImage: Integer;
  BMPs: Array[1..5] of TBitmap;
procedure TForm1.Splitter1Moved(Sender: TObject);
begin
  { check if the blind is closed }
  if Image2.Height <= 1 then
  begin
    { the blind is closed, change the current slide }
    CurImage := CurImage + 1;
    if CurImage = 6 then
       CurImage := 1;
    Image2.Picture.Bitmap := BMPs[CurImage];
  end;
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
  { Initialize the array of slides.
    These must be freed in the OnDestroy event handler. }
  BMPs[1] := TBitmap.Create;
  BMPs[1].LoadFromFile('c:\windows\Fiddle Head.bmp');
  BMPs[2] := TBitmap.Create;
  BMPs[2].LoadFromFile('c:\windows\Rhododendron.bmp');
  BMPs[3] := TBitmap.Create;
  BMPs[3].LoadFromFile('c:\windows\Furry dog.bmp');
  BMPs[4] := TBitmap.Create;
  BMPs[4].LoadFromFile('c:\windows\Soap bubbles.bmp');
  BMPs[5] := TBitmap.Create;
  BMPs[5].LoadFromFile('c:\windows\Gone Fishing.bmp');
  CurImage := 1;
  Image2.Picture.Bitmap := BMPs[1];
end;
procedure TForm1.FormDestroy(Sender: TObject);
var
  I: Integer;
begin
  { clean up }
  for I := 1 to 5 do
    BMPs[I].Free;
end;
 
