unit OnPaint;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    PaintBox1: TPaintBox;
    Button1: TButton;
    procedure PaintBox1Paint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnPaint
// Property: Controls.TGraphicControl.Canvas
// Event: ExtCtrls.TPaintBox.OnPaint

// BeginCode
{
When you do custom drawing, such as shown in the code for
the Button's OnClick event handler below, this drawing will
not be persistent and will be "erased" the first time the
PaintBox component needs to repaint.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
   PaintBox1.Canvas.Brush.Color := clRed;
   PaintBox1.Canvas.FillRect(PaintBox1.Canvas.ClipRect);
   PaintBox1.Canvas.Brush.Color := clBlue;
   PaintBox1.Canvas.Ellipse(0,0,100,50);
end;
{
In order for the drawing to be persistent, you need to also
include an OnPaint event handler that tells the PaintBox how
to redraw itself when it needs to. In the code below, an
ellipse will be drawn everytime the PaintBox renders itself,
but the PaintBox will only paint the client area of the
control red after the Button is clicked. This client area
will only stay red until it is invalidated, but the ellipse
will persist. This behavior is different from the TImage
component, because the TImage component maintains an
internal bitmap that stores this drawing information for
you.
}
procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
   PaintBox1.Canvas.Brush.Color := clBlue;
   PaintBox1.Canvas.Ellipse(0,0,100,50);
end;
// EndCode
// EndExample: OnPaint
end.
