unit OnResizeRequest;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    Edit1: TEdit;
    Button1: TButton;
    procedure RichEdit1ResizeRequest(Sender: TObject; Rect: TRect);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnResizeRequest
// Event: ComCtrls.TCustomRichEdit.OnResizeRequest

// BeginCode
{
The following code resizes the rich edit control to
accommodate growing or shrinking lines of text.  This
example requires a button, a TEdit and a TRichEdit.
Double click on the TRichEdit OnResizeRequest event
to create the event handler.
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  RichEdit1.Lines.Add(Edit1.Text);
end;

procedure TForm1.RichEdit1ResizeRequest(Sender: TObject; Rect: TRect);
begin
  (Sender as TRichEdit).BoundsRect := Rect;
end;
// EndCode
// EndExample: OnResizeRequest
end.
