{
Min, Max, Position, SmallChange, LargeChange, OnScroll example
This example shows how to use a scroll bar to navigate the pages of a page control.  To run this example, place a scroll bar and a page control on a form.  Right click the page control and add 12 pages to it.  Add the following code to the OnCreate event of the form, the OnChange event of the page control, and the OnScroll event of the scroll bar.
Note that the LargeChange and SmallChange properties are set to automatically change the active page by one tab or one row respectively.  The OnScroll event is used to make the actual change in the page control, while the OnChange event of the page control ensures that the scroll bar is kept in sync with changes made directly to the page control.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  I : Integer;
begin
  { First, initialize the page control }
  PageControl1.TabWidth := PageControl1.ClientWidth div 4 - 1;
  PageControl1.ActivePage := PageControl1.Pages[0];
  { set up the scrollbar to reflect the structure of the page control}
  with ScrollBar1 do
  begin
    Max := PageControl1.PageCount - 1;
    Min := 0;
    SmallChange := 1;
    { set LargeChange to a single row of tabs }
    LargeChange := PageControl1.ClientWidth div PageControl1.TabWidth;
  end;
end;
procedure TForm1.PageControl1Change(Sender: TObject);
begin
  with Sender as TPageControl do
    ScrollBar1.Position := ActivePage.PageIndex;
end;
procedure TForm1.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  PageControl1.ActivePage := PageControl1.Pages[ScrollPos];
end; 
