unit OnSelectionChange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure RichEdit1SelectionChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnSelectionChange
// Event: ComCtrls.TCustomRichEdit.OnSelectionChange

// BeginCode
{
This example requires a TStatusBar and a TRichEdit.  The
code within the form's OnCreate will take care of sizing the
Rich Edit and setting the OnSelectionChange event to be
handled by RichEdit1SelectionChange (or you can paste the
code directly into the OnSelectionChange event handler.)  As
you type in the Rich Edit control, the current character
location the selection begin and end will display in the
status bar control.
} 
procedure TForm1.RichEdit1SelectionChange(Sender: TObject);
begin
  with RichEdit1 do
    begin
    StatusBar1.SimpleText := '  Selection Start: ' + IntToStr(SelStart) +
      '  Selection End: ' + IntToStr(SelStart + SelLength);
    end;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  Path = 'OVERVIEW.RTF';
begin
  with RichEdit1 do
  begin
    Lines.LoadFromFile(Path);
    Align := alClient;
    OnSelectionChange := RichEdit1SelectionChange;
  end;
  StatusBar1.SimplePanel := True;
end;
// EndCode
// EndExample: OnSelectionChange
end.
