unit OnSettingChange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AppEvnts, StdCtrls;

type
  TForm1 = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    Memo1: TMemo;
    procedure ApplicationEvents1SettingChange(Sender: TObject; Flag: Integer;
      const Section: string; var Result: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: OnSettingChange
// Event: AppEvnts.TCustomApplicationEvents.OnSettingChange
// Variable: SysUtils.SysLocale
// Routine: SysUtils.BoolToStr
// Method: Classes.TStrings.BeginUpdate
// Method: Classes.TStrings.EndUpdate

// BeginCode
{
This example requires that a memo and a TApplicationEvent be
added to the form.  Change the Windows Locale by using the
Regional and Language Options in the Windows Control Panel.
}
procedure TForm1.ApplicationEvents1SettingChange(Sender: TObject; Flag: Integer; const Section: string; var Result: Integer);
begin
  Memo1.Lines.BeginUpdate;
  try
    Memo1.Lines.Add(Format('Section  = %s', [Section]));
    Memo1.Lines.Add(Format('Flags  = %.8x', [Flag]));
    if AnsiSameStr(Section, 'intl') then
    with SysLocale do
    begin
      Memo1.Lines.Add(Format('DefaultLCID  = %.8x', [DefaultLCID]));
      Memo1.Lines.Add(Format('PriLangID  = %.8x', [PriLangID]));
      Memo1.Lines.Add(Format('SubLangID  = %.8x', [SubLangID]));
      Memo1.Lines.Add(Format('FarEast  = %s', [BoolToStr(FarEast, True)]));
      Memo1.Lines.Add(Format('MiddleEast  = %s', [BoolToStr(MiddleEast, True)]));
    end;
    Memo1.Lines.Add('');
  finally
    Memo1.Lines.EndUpdate;
  end;
//  Result:= 0;
end;
// EndCode
// EndExample: OnSettingChange
end.
