unit UsingPictureDialogsExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, ExtDlgs;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    OpenPictureDialog1: TOpenPictureDialog;
    SavePictureDialog1: TSavePictureDialog;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: UsingPictureDialogs
// Class: ExtDlgs.TOpenPictureDialog
// Class: ExtDlgs.TSavePictureDialog
// Method: ExtDlgs.TOpenPictureDialog.Execute
// Method: ExtDlgs.TSavePictureDialog.Execute

// BeginCode
{
This example uses an image, two buttons, an open picture dialog
and a save picture dialog on a form. Clicking on the Open/Save button
executes the open/save picture dialog.
An exception is raised when trying to open a file that
does not exist, or when trying to overwrite a file using the
save dialog.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  { execute an open picture dialog }
  if OpenPictureDialog1.Execute then
    { first check if file exists }
    if FileExists(OpenPictureDialog1.FileName) then
      { if it exists, load the data into the image component }
      Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName)
    else
      { otherwise raise an exception }
      raise Exception.Create('File does not exist.');
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  { execute a save picture dialog }
  if SavePictureDialog1.Execute then
    { first check if file exists }
    if FileExists(SavePictureDialog1.FileName) then
      { if it exists, raise an exception }
      raise Exception.Create('File already exists. Cannot overwrite.')
    else
      { otherwise, save the image data into the file }
      Image1.Picture.SaveToFile(SavePictureDialog1.FileName);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Image1.Canvas.Refresh;
end;
// EndCode
// EndExample: UsingPictureDialogs

end.

