unit OpenTextFileDialog;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtDlgs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    OpenTxtDlg : TOpenTextFileDialog;
    SaveTxtDlg : TSaveTextFileDialog;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
// BeginExample: TOpenTextFileDialog
// Class: ExtDlgs.TOpenTextFileDialog
// Class: ExtDlgs.TSaveTextFileDialog
// Property: ExtDlgs.TOpenTextFileDialog.Encodings
// Property: ExtDlgs.TOpenTextFileDialog.EncodingIndex
// Method: Classes.TStrings.LoadFromFile

// BeginCode
{
This example shows how to use the TOpenTextFileDialog and
TSaveTextFileDialog to handle files with specific encodings.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  Encoding : TEncoding;
  EncIndex : Integer;
  Filename : String;
begin
  if OpenTxtDlg.Execute(Self.Handle) then
    begin
    //selecting the filename and encoding selected by the user
    Filename := OpenTxtDlg.FileName;

    EncIndex := OpenTxtDlg.EncodingIndex;
    Encoding := OpenTxtDlg.Encodings.Objects[EncIndex] as TEncoding;

    //checking if the file exists
    if FileExists(Filename) then
      //display the contents in a memo based on the selected encoding
      Memo1.Lines.LoadFromFile(FileName, Encoding)
    else
      raise Exception.Create('File does not exist.');
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  Encoding : TEncoding;
  EncIndex : Integer;
  Filename : String;
begin
  if SaveTxtDlg.Execute(Self.Handle) then
    begin
    //selecting the filename and encoding selected by the user
    Filename := SaveTxtDlg.FileName;

    EncIndex := SaveTxtDlg.EncodingIndex;
    Encoding := SaveTxtDlg.Encodings.Objects[EncIndex] as TEncoding;

    //checking if the file exists
    if FileExists(Filename) then
      raise Exception.Create('File already exists.')
    else
      //save to file based on the selected encoding
      Memo1.Lines.LoadFromFile(FileName, Encoding);
    end;

end;

procedure TForm1.FormCreate(Sender: TObject);
var
  encodings : TStrings;
begin
  OpenTxtDlg := TOpenTextFileDialog.Create(Self);
  SaveTxtDlg := TSaveTextFileDialog.Create(Self);

  // create a new string list that holds encoding info
  encodings := TStringList.Create();

  // add some encodings to the list
  encodings.AddObject('ASCII', TEncoding.ASCII);
  encodings.AddObject('UNICODE', TEncoding.Unicode);
  encodings.AddObject('UTF8', TEncoding.UTF8);

  OpenTxtDlg.Encodings.Assign(encodings);
  SaveTxtDlg.Encodings.Assign(encodings);

  OpenTxtDlg.Filter := 'Text files (*.txt)|*.TXT|XML files (*.xml)|*.XML|Any file (*.*)|*.*';
  SaveTxtDlg.Filter := 'Text files (*.txt)|*.TXT|XML files (*.xml)|*.XML|Any file (*.*)|*.*';

end;
// EndCode
// EndExample: TOpenTextFileDialog
end.
