unit PageControlChange;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    procedure PageControl1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PageControlChange
// Event: ComCtrls.TCustomTabControl.OnChange
// Event: Forms.TCustomForm.OnShow

// BeginCode
{
This project requires a Page Control.  You will need to
populate the Page Control by right clicking and selecting
New Page from the context menu. As the tabs are selected by
the user, the Page Control OnChange event fires, which
causes the form caption to display the captions of each of
the TTabSheets attached to the Page Control.
Note the use of the Forms OnShow event handler to set the
caption when the form first appears.  This occurs before
any changes trigger the OnChange event of the Page Control.
} 
procedure TForm1.PageControl1Change(Sender: TObject);
begin
  Caption := ' Now working on tab:  ' + PageControl1.ActivePage.Caption;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  PageControl1Change(Sender);
end;
// EndCode
// EndExample: PageControlChange
end.
