unit PageControlChanging;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Edit1: TEdit;
    procedure PageControl1Changing(Sender: TObject; var AllowChange: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PageControlChanging
// Event: ComCtrls.TCustomTabControl.OnChanging

// BeginCode
{
This project requires a TPageControl, several TTabSheets (to
add sheets, right click the Page Control and select "New
Page" from the context menu), and a TEdit control on the
first tab sheet.  The user is not allowed to change to a new
page if the active page is "TabSheet1" and there is no text
in the Edit Control.
} 
procedure TForm1.PageControl1Changing(Sender: TObject; var AllowChange: Boolean);
begin
  if ((Sender as TPageControl).ActivePage = TabSheet1) then
    AllowChange := (Edit1.Text <> '')
  else
    AllowChange := True;
end;
// EndCode
// EndExample: PageControlChanging

procedure TForm1.FormCreate(Sender: TObject);
var
  i : Integer;
const
  colorpalette: Array[0..11] of TColor =
    (clRed, clGreen, clYellow, clBlue, clWhite, clFuchsia,
    clTeal, clNavy, clMaroon, clLime, clOlive, clPurple);
begin
  for i := 0 to PageControl1.PageCount - 1 do
    PageControl1.Pages[i].Brush.Color:= colorPalette[i];
end;

end.
