unit PageSize;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    ScrollBar1: TScrollBar;
    procedure FormCreate(Sender: TObject);
    procedure RichEdit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PageSize
// Property: StdCtrls.TScrollBar.PageSize

// Warning: Doesn't work.  Only sets the tabsize.  Doesn't scroll the text or anything.

// BeginCode
{
The following code sets the thumb tab of a scroll bar so
that it represents the proportion of the scrolling range
that is visible:
} 
procedure SetThumbTab(wincontrol: TWinControl);
var
  TrackHeight: Integer; { the size of the scroll bar track }
  MinHeight: Integer; { the default size of the thumb tab }
begin
  MinHeight := GetSystemMetrics(SM_CYVTHUMB); { save default size }
  with Form1.ScrollBar1 do
  begin
    TrackHeight := wincontrol.ClientHeight - 2 * GetSystemMetrics(SM_CYVSCROLL);
    PageSize := TrackHeight div (Max - Min + 1);
    if PageSize < MinHeight then PageSize := MinHeight;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := False;
  RichEdit1.Lines.LoadFromFile(Path);
  SetThumbTab(RichEdit1);
end;
procedure TForm1.RichEdit1Change(Sender: TObject);
begin
  SetThumbTab(RichEdit1);
end;
// EndCode
// EndExample: PageSize
end.
