{
PageSize example
The following code sets the thumb tab of a scroll bar so that it represents the proportion of the scrolling range that is visible:
} 
var
  TrackHeight: Integer; { the size of the scroll bar track }
  MinHeight: Integer; { the default size of the thumb tab }
begin
  MinHeight := GetSystemMetrics(SM_CYVTHUMB); { save default size }
  with ScrollBar1 do
  begin
    TrackHeight := ClientHeight - 2 * GetSystemMetrics(SM_CYVSCROLL);
    PageSize := TrackHeight div (Max - Min + 1);
    if PageSize < MinHeight then PageSize := MinHeight;
  end;
end; 
