unit PlainText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    RichEdit1: TRichEdit;
    RichEdit2: TRichEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PlainTextProperty
// Property: ComCtrls.TCustomRichEdit.PlainText
// Method: Classes.TStrings.LoadFromFile

// BeginCode
{
This example requires two TRichEdit controls placed on the 
form.  When the form becomes visible, the first Rich Edit 
control will display the rich text in its raw form, including
formatting characters. The second will show the rich text in 
its intended format.
}

procedure TForm1.FormCreate(Sender: TObject);
const
  // you may need to change this path to suit your environment
  Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := True;
  RichEdit1.Lines.LoadFromFile(Path);
  RichEdit1.ScrollBars := ssVertical;
  RichEdit2.PlainText := False;
  RichEdit2.Lines.LoadFromFile(Path);
  RichEdit2.ScrollBars := ssVertical;
end;
// EndCode
// EndExample: PlainTextProperty
end.
