{
This example shows how to use the BeforeGetRecords event handler (a TRemoteEventType value) to send the provider information it needs for incremental data fetching. Before fetching the next data packet, the client dataset packages up the key value of the last record so that the provider knows where to begin the next data packet. It also sends some application-specific information, which is stored in Memo1.
} 
procedure TForm1.ClientDataSet1BeforeGetRecords(Sender: TObject; var OwnerData: OleVariant);
var
  LastValue: OleVariant;
  CDSClone:ClientDataSet;
begin
  if ClientDataSet1.Active then
  begin
    CDSClone := ClientDataSet.Create(Form1);
    try
      CDSClone.CloneCursor(ClientDataSet1, True);
      { turn off FetchOnDemand so that the clone only fetches
        the last LOCAL record }
      CDSClone.FetchOnDemand := False;
      CDSClone.Last;
      LastValue := CDSClone.Fields[0].AsString;
      CDSClone.Close;
    finally
      CDSClone.Free;
    end;
  end else
    LastValue := NULL;
  OwnerData := VarArrayOf([Memo1.Lines.Text, LastValue]);
end; 

