unit PrintToFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons;

type
  TForm1 = class(TForm)
    SaveDialog1: TSaveDialog;
    PrintDialog1: TPrintDialog;
    BitBtn1: TBitBtn;
    RichEdit1: TRichEdit;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PrintToFile
// Method: Dialogs.TPrintDialog.PrintToFile
// Method: Classes.TStrings.SaveToFile

// BeginCode
{
This example displays a print dialog box with a Print to
File check box, and then prints the contents of a rich edit
control to the indicated destination:
Verify that the file is saved by the SaveDialog.
}
procedure TForm1.BitBtn1Click(Sender: TObject);
begin
with PrintDialog1 do
  begin
  Options := [poPrintToFile];
  PrintToFile := True;
  if Execute then
    begin
    if PrintToFile then
      begin
      SaveDialog1.Title := 'Print to File: ';

      { Save in UTF8 format }
      if SaveDialog1.Execute then
        RichEdit1.Lines.SaveToFile(SaveDialog1.FileName, TEncoding.UTF8);
      end
    else
      RichEdit1.Print('');
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  // you may need to change this path to suit your environment
  Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := False;

  { Load from UTF8 format }
  RichEdit1.Lines.LoadFromFile(Path, TEncoding.UTF8);
  RichEdit1.ScrollBars := ssVertical;
end;
// EndCode
// EndExample: PrintToFile
end.
