unit PrinterOrientation;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Portrait: TRadioButton;
    Landscape: TRadioButton;
    procedure PortraitClick(Sender: TObject);
    procedure LandscapeClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PrinterOrientation
// Property: Printers.TPrinter.Orientation

// BeginCode
{
This example uses two radio buttons on a form named
Landscape and Portrait. The form also includes a button.
When the user selects an orientation by clicking one of the
radio buttons and then clicks the button to print one line
of text, the print job prints using the selected orientation:
}
uses Printers;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Printer.BeginDoc;
  Printer.Canvas.TextOut(100,100,'Hi there');
  Printer.EndDoc;
end;

procedure TForm1.LandscapeClick(Sender: TObject);
begin
  Printer.Orientation := poLandscape;
end;

procedure TForm1.PortraitClick(Sender: TObject);
begin
  Printer.Orientation := poPortrait;
end;
// EndCode
// EndExample: PrinterOrientation
end.
