
(*
 Delphi Object and Component Reference
# {bmc bm9.BMP} ReadBool, ReadInteger, ReadString example
This cross-platform example reads the myapp.ini file and displays on the form the status of your auto save options.
Before you run this example, you must include IniFiles.hpp in your unit.
*) 
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TIniFile *pIniFile = new TIniFile("MyApp.ini");
  if (pIniFile->ReadBool("AutoLoad", "FormProperties", false) == true)
  {
    Visible = pIniFile->ReadBool("FormOptions", "Visible", true);
    Color = (Graphics::TColor)pIniFile->ReadInteger("FormOptions", "Color", clNormalBackground);
    Caption = pIniFile->ReadString("FormOptions", "Caption", "Main");
  }
  delete pIniFile;
} 
