unit PrinterPageNumber;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    StatusBar1: TStatusBar;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PrinterPageNumber
// Property: Printers.TPrinter.PageNumber

// BeginCode
{
This example uses a button and a status bar on a form. When
the user clicks the button, one line of text is printed on
six separate pages. As each page is printed, a message
indicating the number of the page being printed appears on
the status bar.  To run this example successfully, you must
add Printers to the uses clause of your unit and set the
SimplePanel property of the status bar to true.
}
uses Printers;

procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  StatusBar1.SimplePanel := True; { so that SimpleText will work }
  Printer.BeginDoc;
  for I := 1 to 6 do
  begin
    Printer.Canvas.TextOut(100, 100, 'Object Pascal is great');
    StatusBar1.SimpleText := 'Now printing page ' + IntToStr(Printer.PageNumber);
    Printer.NewPage;
  end;
  Printer.EndDoc;

end;
// EndCode
// EndExample: PrinterPageNumber
end.
