
(*
 Delphi Object and Component Reference
# {bmc bm18.BMP} {bmc bm10.BMP} PageNumber example
This example uses a button on a form. When the user clicks the button, one line of text is printed on six separate pages. As each page is printed, a message indicating the number of the page being printed appears on the status bar.
To run this example successfully, you must add Printers to the uses clause of your unit and set the SimplePanel property of the status bar to true.
*) 
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  StatusBar1.SimplePanel := True; { so that SimpleText will work }
  Printer.BeginDoc;
  for I := 1 to 6 do
  begin
    Printer.Canvas.TextOut(100, 100, 'Object Pascal is great');
    StatusBar1.SimpleText := 'Now printing page ' + IntToStr(Printer.PageNumber));
    Printer.NewPage;
  end;
  Printer.EndDoc;
end; 
