unit PrinterPageWidth;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: PrinterPageWidth
// Property: Printers.TPrinter.PageWidth

// BeginCode
{
This example uses a button and a memo on a form. When the
user clicks the button, the content of the memo is printed,
with a 200-pixel border around the page. To run this example
successfully, include <Printers.hpp> in your unit file.
Note: The TMemo will wrap the lines of the text files, so to
see the TextRect clip, the memo width must be large and the
lines in the text file must be long.
}
uses Printers;

procedure TForm1.Button1Click(Sender: TObject);
var
  X, Y, I, margin: Integer;
begin
  with Printer do
  begin
    BeginDoc;
    margin := 1000;
    X := margin;
    Y := margin;
    I := 0;
    while(Y < PageHeight) do
    begin
      Canvas.TextRect(Rect(X, Y, PageWidth-margin, PageHeight-margin),
                    X, Y, Memo1.Lines[I]);
      Y := Y + 100;
      I := I + 1;
    end;
    EndDoc;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Memo1.Width := 1000;
  Memo1.Lines.LoadFromFile('readme.txt');
end;
// EndCode
// EndExample: PrinterPageWidth
end.
