unit ProcessMessages;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ProcessMessages
// Method: Forms.TApplication.ProcessMessages

// BeginCode
{
This example uses two buttons that are long enough to 
accommodate lengthy captions on a form. When the user clicks
the button with the caption Ignore Messages, the code begins
to generate a long series of random numbers. If the user 
tries to resize the form while the handler is running, 
nothing happens until the handler is finished. When the user
clicks the button with the caption Process Messages, more 
random numbers are generated, but the application can still 
respond to a series of events, such as resizing the form
and printing text.
Note: How quickly these event handlers run depends on the 
microprocessor of your computer. A message appears on the 
form informing you when the handler has finished executing.
}
const magicnumber = 500;
procedure TForm1.FormCreate(Sender: TObject);
begin
  Button1.Caption := 'Ignore Messages';
  Button2.Caption := 'Process Messages';
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  I, J: Integer;
  X, Y: Word;
begin
  I := 0;
  J := 0;
  Canvas.TextOut(10, 10, 'The Button1Click handler has started');
  Application.ProcessMessages; // Just to get the message out.
  while I < magicnumber do
  begin
    Randomize;
    while J < magicnumber do
    begin
      Sleep(10);
      Y := Random(J);
      Inc(J);
    end;
    X := Random(I);
    Inc(I);
  end;
  Canvas.TextOut(10, 10, 'The Button1Click handler is finished   ');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  I, J: Integer;
  X, Y: Word;
begin
  I := 0;
  J := 0;
  Canvas.TextOut(10, 10, 'The Button2Click handler has started');
  while I < magicnumber do
  begin
    Randomize;
    while J < magicnumber do
    begin
      Y := Random(J);
      Inc(J);
      Sleep(10);
      Application.ProcessMessages;
    end;
    X := Random(I);
    Inc(I);
  end;
  Canvas.TextOut(10, 10, 'The Button2Click handler is finished   ');
end; 
// EndCode
// EndExample: ProcessMessages
end.
