unit ProgressBarPosition;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    ProgressBar1, ProgressBar2: TProgressBar;
    Memo1: TMemo;
    Label1, Label2: TLabel;
    procedure Memo1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ProgressBarPosition
// Property: ComCtrls.TProgressBar.Min
// Property: ComCtrls.TProgressBar.Max
// Property: ComCtrls.TProgressBar.Position

// BeginCode
{
This example requires two ProgressBars, two labels and a
Memo.  The ProgressBar and the label captions are updated as
the mouse moves inside the Memo.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  ProgressBar1.Min := 0;
  ProgressBar1.Max := Memo1.Width;
  ProgressBar2.Min := 0;
  ProgressBar1.Max := Memo1.Height;
end;

procedure TForm1.Memo1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  Label1.Caption := InttoStr(X);
  Label2.Caption := InttoStr(Y);
  ProgressBar1.Position := X;
  ProgressBar2.Position := Y;
end;
// EndCode
// EndExample: ProgressBarPosition
end.
