unit ReadComponentResFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

// BeginExample: ReadComponentResFile
// Routine: Classes.ReadComponentResFile
// Routine: Classes.WriteComponentResFile
// Routine: Classes.RegisterClasses

// BeginCode
{
The following code defines a component class (TStreamable
class) and a persistent class (TContainedClass) that is the
type of a property on the component class. When a button is
clicked, an instance of the component class is created, saved
to a file, deleted, and then loaded from the file. By setting
a breakpoint on the property setter of the TContainedClass
SomeData property, you can watch how the streaming system
sets property values when it reads them from a file.
The following unit defines the classes to stream:
} 

{$R-,T-,H+,X+}

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TContainedClass = class(TPersistent)
  private
    FSomeData: Integer;
    procedure SetSomeData(Value: Integer);
  public
    constructor Create;
    // Only published properties
    // are automatically streamed.
  published
    property SomeData: Integer read FSomeData write SetSomeData;
  end;

  TStreamableClass = class(TComponent)
  private
    FContainedClass: TContainedClass;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    // Only published properties
    // are automatically streamed.
  published
    property ContainedClass: TContainedClass read FContainedClass write FContainedClass;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TContainedClass.SetSomeData(Value: Integer);
begin
{ Place a breakpoint here and notice how the data is streamed back. }
  FSomeData := Value;
end;

constructor TContainedClass.Create;
begin
  FSomeData := 42;
end;

constructor TStreamableClass.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FContainedClass := TContainedClass.Create;
end;

destructor TStreamableClass.Destroy;
begin
  FContainedClass.Free;
end;

{
The following OnClick event handler should be added to a
button on the applications main form. It causes the above
classes to be streamed out and in.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  AClassInstance: TStreamableClass;
begin
  AClassInstance := TStreamableClass.Create(nil);
  WriteComponentResFile('Test', AClassInstance);
  FreeAndNil(AClassInstance);

  AClassInstance := Classes.ReadComponentResFile('Test', nil) as TStreamableClass;
  FreeAndNil(AClassInstance);
end;

initialization
  RegisterClasses([TContainedClass, TStreamableClass]);
// EndCode
// EndExample: ReadComponentResFile
end.
