{
ReadComponentResFile, WriteComponentResFile example
The following code defines a component class (TStreamable class) and a persistent class (TContainedClass) that is the type of a property on the component class. When a button is clicked, an instance of the component class is created, saved to a file, deleted, and then loaded from the file. By setting a breakpoint on the property setter of the TContainedClass SomeData property, you can watch how the streaming system sets property values when it reads them from a file.
The following unit defines the classes to stream:
} 
unit StrmExmpl;

{$R-,T-,H+,X+}

interface
uses Classes

type
TContainedClass = class(TPersistent)
private:
  FSomeData: Integer;
  procedure SetSomeData(Value: Integer);
  public:
    constructor Create; override;
  // Only published properties
  // are automatically streamed.
  published:
    property SomeData: Integer read FSomeData write SetSomeData;
end;

TStreamableClass = class(TComponent)
private:
  FContainedClass: TContainedClass;
  public:
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  // Only published properties
  // are automatically streamed.
  published:
    property ContainedClass: TContainedClass read FContainedClass write FContainedClass;
end;

implementation

procedure TContainedClass.SetSomeData(Value: Integer);
begin
{ Place a breakpoint here and notice how the data is streamed back. }
  FSomeData := Value;
end;
constructor TContainedClass.Create;
begin
  FSomeData := 42;
end;
constructor TStreamableClass.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FContainedClass = TContainedClass.Create;
end;
destructor TStreamableClass.Destroy;
begin
  FContainedClass.Free;
end;
initialization
  RegisterClasses([TContainedClass, TStreamableClass]);
finalization
end.
The following OnClick event handler should be added to a button on the applications main form. It causes the above classes to be streamed out and in. Note that you must add StrmExmpl to the uses clause of unit1.
*) 
procedure TForm1.Button1Click(Sender: TObject);
var
  AClassInstance: TStreamableClass;
begin
  AClassInstance := TStreamableClass.Create(nil);
  WriteComponentResFile('C:\Test', AClassInstance);
  FreeAndNil(AClassInstance);

  AClassInstance := ReadComponentResFile('C:\Test', nil) as TStreamableClass;
  FreeAndNil(AClassInstance);
end; 
