unit RecordCount;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    ProgressBar1: TProgressBar;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Customers: TTable;
implementation

{$R *.dfm}

// BeginExample: RecordCount
// Property: ComCtrls.TProgressBar.Min
// Property: ComCtrls.TProgressBar.Max
// Property: ComCtrls.TProgressBar.Position
// Property: DB.TDataSet.RecordCount
// Method: DB.TDataSet.First
// Method: DB.TDataSet.Next
// Method: DB.TDataSet.AppendRecord

// BeginCode
{
Reads through all records in the Customers table.
Updates the ProgressBar accordingly.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  i: Integer;
begin
  with ProgressBar1 do
  begin
    Min := 0;
    Max := Customers.RecordCount;
    Customers.First;
    for i := Min to Max do
    begin
      Position := i;
      Customers.Next;
      // do something with the current record
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Customers:= TTable.Create(Form1);
  with Customers do
  begin
    DatabaseName := 'DBDEMOS';
    TableType := ttParadox;
    TableName := 'CustInfo';
    Active := False;
//  Overwrite any existing table
    if Customers.Exists then
    begin
      Customers.Close;
      Customers.DeleteTable;
    end;
    begin
      { The Table component must not be active }
      { First, describe the type of table and give }
      { it a name }
      { Next, describe the fields in the table }
      with FieldDefs do
      begin
        Clear;
        with AddFieldDef do
        begin
          Name := 'Field1';
          DataType := ftInteger;
          Required := True;
        end;
        with AddFieldDef do
        begin
          Name := 'Field2';
          DataType := ftString;
          Size := 30;
        end;
      end;
      { Next, describe any indexes }
      with IndexDefs do
      begin
        Clear;
        { The 1st index has no name because it is
        { a Paradox primary key }
        with AddIndexDef do
        begin
          Name := '';
          Fields := 'Field1';
          Options := [ixPrimary];
        end;
        with AddIndexDef do
        begin
          Name := 'Fld2Indx';
          Fields := 'Field2';
          Options := [ixCaseInsensitive];
        end;
      end;
      { Call the CreateTable method to create the table }
      CreateTable;
      Customers.Active:= True;
      for i := 1 to 100 do
        Customers.AppendRecord([i*111, i*222]);
    end;
  end;
  DS2.DataSet:= Customers;
  DBGrid2.DataSource.DataSet:= Customers;
  Customers.Active:= True;
end;
// EndCode
// EndExample: RecordCount
end.
