unit RegisterComponents;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

// BeginExample: RegisterComponents
// Routine: Classes.RegisterComponents
// Method: Classes.TComponent.FreeNotification

// BeginCode
{
The following code registers several components, some on the
MySystem palette page that already exist, and some on a new
palette page that is created when the components are
installed.
} 
type
  TForm1 = class(TForm)
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TDemoLabel = class(TGraphicControl)
  private
    FFocusControl: TWinControl;
    procedure SetFocusControl(Value: TWinControl);
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
  protected
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Caption;
    property Color;
    property FocusControl: TWinControl read FFocusControl write SetFocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
  end;

procedure Register;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TDemoLabel }

constructor TDemoLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FComponentStyle := FComponentStyle - [csInheritable];
end;

procedure TDemoLabel.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FFocusControl) then
    FFocusControl := nil;
end;

procedure TDemoLabel.SetFocusControl(Value: TWinControl);
begin
  FFocusControl := Value;

  { Calling FreeNotification ensures that this component will receive an
    opRemove when Value is either removed from its owner or when it is
    destroyed. }

  Value.FreeNotification(Self);
end;

procedure TDemoLabel.Paint;
var
  Rect: TRect;
begiN
  Rect := ClientRect;
  Canvas.Font := Font;
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Rect);
  DrawText(Canvas.Handle, PChar(Caption), Length(Caption), Rect,
    DT_EXPANDTABS or DT_WORDBREAK or DT_LEFT);
end;

procedure TDemoLabel.CMDialogChar(var Message: TCMDialogChar);
begin
  if (FFocusControl <> nil) and Enabled and
    IsAccel(Message.CharCode, Caption) then
    with FFocusControl do
      if CanFocus then
      begin
        SetFocus;
        Message.Result := 1;
      end;
end;

procedure TDemoLabel.CMTextChanged(var Message: TMessage);
begin
  inherited;
  Invalidate;
end;

procedure Register;
begin
  Classes.RegisterComponents('MySystem', [TDemoLabel]);
  Classes.RegisterComponents('Samples', [TDemoLabel]);
end;
// EndCode
// EndExample: RegisterComponents
end.
