unit ReplaceText;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ReplaceDialog1: TReplaceDialog;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ReplaceDialog1.Execute;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  // you may need to change this path to suit your environment
  Path = 'OverView.RTF';
begin
  Memo1.Lines.LoadFromFile(Path);
end;

// BeginExample: ReplaceText
// Event: Dialogs.TReplaceDialog.OnReplace
// Property: Dialogs.TReplaceDialog.ReplaceText

// BeginCode
{
The following event handler searches a TMemo object called
Memo1 and replaces FindText with ReplaceText. It uses
TMemos SelStart, SelLength, and SelText properties.
}
procedure TForm1.ReplaceDialog1Replace(Sender: TObject);
var
  SelPos: Integer;
begin
  with TReplaceDialog(Sender) do
  begin
  { Perform a global case-sensitive search for FindText in Memo1 }
    SelPos := Pos(FindText, Memo1.Lines.Text);
    if SelPos > 0 then
    begin
      Memo1.SelStart := SelPos - 1;
      Memo1.SelLength := Length(FindText);
      { Replace selected text with ReplaceText }
      Memo1.SelText := ReplaceText;
    end
    else MessageDlg(Concat('Could not find "', FindText, '" in Memo1.'), mtError, [mbOk], 0);
  end;
end; 
// EndCode
// EndExample: ReplaceText
end.
