{
OnReplace, ReplaceText example
The following event handler searches a TMemo object called Memo1 and replaces FindText with ReplaceText. It uses TMemos SelStart, SelLength, and SelText properties.
} 
procedure TForm1.ReplaceDialog1Replace(Sender: TObject);
var
  SelPos: Integer;
begin
  with TReplaceDialog(Sender) do
  begin
  { Perform a global case-sensitive search for FindText in Memo1 }
    SelPos := Pos(FindText, Memo1.Lines.Text);
    if SelPos > 0 then
    begin
      Memo1.SelStart := SelPos - 1;
      Memo1.SelLength := Length(FindText);
      { Replace selected text with ReplaceText }
      Memo1.SelText := ReplaceText;
    end
    else MessageDlg(Concat('Could not find "', FindText, '" in Memo1.'), mtError, [mbOk], 0);
  end;
end; 
