unit RotatedFont;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: RotatedFont
// Property: Graphics.TFont.Handle
// Routine: System.FillChar
// Property: Graphics.TCanvas.Font

// BeginCode
{
This example creates a rotated font and displays it on the
form by assigning the handle of the rotated to the Forms
Canvas Font via the Fonts Handle property.  Rotating fonts
is a straightforward process, so long as the Windows Font
Mapper can supply a rotated font based on the font you
request. If you are using a TrueType font there is virtually
no reason for failure.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  lf: LOGFONT; // Windows native font structure
begin
  Canvas.Brush.Style := bsClear; // set the brush style to transparent
  FillChar(lf, SizeOf(lf), Byte(0));
  lf.lfHeight := 20;
  lf.lfEscapement := 10 * 45; // degrees to rotate
  lf.lfOrientation := 10 * 45;
  lf.lfCharSet := DEFAULT_CHARSET;
  StrCopy(lf.lfFaceName, 'Tahoma');

  Canvas.Font.Handle := CreateFontIndirect(lf);
  Canvas.TextOut(10, 100, 'Rotated text'); // output the rotated font
end;
// EndCode
// EndExample: RotatedFont
end.
