{
Rotated Font example
This example creates a rotated font and displays it on the form by assigning the handle of the rotated to the Forms Canvas Font via the Fonts Handle property. 
Rotating fonts is a straightforward process, so long as the Windows Font Mapper can supply a rotated font based on the font you request. If you are using a TrueType font there is virtually no reason for failure.
} 
procedure TForm1::Button1Click(Sender: TObject);
var
  lf: LOGFONT; // Windows native font structure
begin
  Canvas.Brush.Style := bsClear; // set the brush style to transparent
  FillChar(Addr(lf), SizeOf(lf), Byte(0));
  lf.lfHeight := 20;
  lf.lfEscapement := 10 * 45; // degrees to rotate
  lf.lfOrientation := 10 * 45;
  lf.lfCharSet := DEFAULT_CHARSET;
  StrCpy(lf.lfFaceName, 'Tahoma');

  Canvas.Font.Handle := CreateFontIndirect(Addr(lf));
  Canvas.TextOut(10, 100, 'Rotated text'); // output the rotated font
end;
 
