unit RoundRect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: RoundRect
// Method: Graphics.TCanvas.RoundRect
// Method: Graphics.TPen.Width

// BeginCode
{
This example draws many rounded rectangles of various sizes
and colors on a form maximized to fill the entire screen:
} 
var
  X, Y, DX, DY: Integer;
procedure TForm1.FormActivate(Sender: TObject);
begin
  WindowState := wsMaximized;
  Timer1.Interval := 50;
  Randomize;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  X := Random(Screen.Width - 10);
  Y := Random(Screen.Height - 10);
  Canvas.Pen.Color := Random(65535);
  Canvas.Pen.Width := Random(7);
  DX := Random(400);
  DY := Random(400);
  Canvas.RoundRect(X, Y, X + DX, Y + DY, DX div 2, DY div 2);
end;
// EndCode
// EndExample: RoundRect
end.
