unit SaveToFile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    ConvertIcon2Bitmap: TButton;
    OpenDialog1: TOpenDialog;
    procedure ConvertIcon2BitmapClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: SaveToFile
// Method: Graphics.TPicture.SaveToFile
// Method: Graphics.TIcon.Create
// Property: Graphics.TGraphic.Height
// Property: Graphics.TGraphic.Width
// Property: ExtCtrls.TImage.Canvas
// Routine: SysUtils.ChangeFileExt

// BeginCode
{
This example converts a specified icon to a bitmap. To run 
this example, add an image, a button, and an Open dialog to 
a form. Name the button ConvertIcon2Bitmap, and add the 
following code as its OnClick event handler.
} 
procedure TForm1.ConvertIcon2BitmapClick(Sender: TObject);
var 
  s : string;
  Icon: TIcon;
begin
  OpenDialog1.DefaultExt := '.ICO';
  OpenDialog1.Filter := 'icons (*.ico)|*.ICO';
  OpenDialog1.Options := [ofOverwritePrompt, ofFileMustExist, ofHideReadOnly ];
  if OpenDialog1.Execute then
  begin
    Icon := TIcon.Create;
    try
      Icon.Loadfromfile(OpenDialog1.FileName);
      s:= ChangeFileExt(OpenDialog1.FileName,'.BMP');
      Image1.Width := Icon.Width;
      Image1.Height := Icon.Height;
      Image1.Canvas.Draw(0,0,Icon);
      Image1.Picture.SaveToFile(s);
      ShowMessage(OpenDialog1.FileName + ' Saved to ' + s);
    finally
      Icon.Free;
    end;
  end;
end; 
// EndCode
// EndExample: SaveToFile
end.
