unit Scanline;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ImgList;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ImageList1: TImageList;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ScanLine
// Property: Graphics.TBitmap.ScanLine
// Property: Graphics.TGraphic.Height
// Property: Graphics.TGraphic.Width
// Property: Graphics.TBitmap.PixelFormat

// BeginCode

{
This example shows how to draw directly to a Bitmap.  It
loads a bitmap from a file and then copies it to another
bitmap twice it's size.  Then the two bitmaps are
displayed on the form canvas.
}
procedure TForm1.Button1Click(Sender: TObject);
type
  TRGBTripleArray = ARRAY[Word] of TRGBTriple;
  pRGBTripleArray = ^TRGBTripleArray; // use a PByteArray for pf8bit color
var
  x,y : Integer;
  bx, by : Integer;
  BitMap, BigBitMap : TBitMap;
  P, bigP : pRGBTripleArray;
  pixForm, bigpixForm : TPixelFormat;
begin
  BitMap := TBitMap.create;
  BigBitMap := TBitMap.create;
  try
    BitMap.LoadFromFile('littlefac.bmp');
    pixForm := BitMap.PixelFormat;
    bigpixForm := BigBitMap.PixelFormat;
    BitMap.PixelFormat := pf24bit;
    BigBitMap.PixelFormat := pf24bit;
    BigBitMap.Height := BitMap.Height * 2;
    BigBitMap.Width := BitMap.Width * 2;
    for y := 0 to BitMap.Height - 1 do
    begin
      P := BitMap.ScanLine[y];
      for x := 0 to BitMap.Width - 1 do
      begin
        bx := x * 2;
        by := y * 2;
        bigP := BigBitMap.ScanLine[by];
        bigP[bx] := P[x];
        bigP[bx + 1] := P[x];
        bigP := BigBitMap.ScanLine[by + 1];
        bigP[bx] := P[x];
        bigP[bx + 1] := P[x];
      end;
    end;
    Canvas.Draw(0, 0, BitMap);
    Canvas.Draw(200, 200, BigBitMap);
  finally
    BitMap.Free;
    BigBitMap.Free;
  end;
end;
// EndCode
// EndExample: ScanLine
end.
