unit ScrollBarIncrement;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ScrollBarIncrement
// Property: Forms.TControlScrollBar.Increment
// Property: Forms.TControlScrollBar.Position
// Property: Forms.TControlScrollBar.Range
// Property: Forms.TControlScrollBar.Visible
// Property: Forms.TCustomForm.ClientWidth
// Property: Forms.TScrollingWinControl.HorzScrollBar

// BeginCode
{
This example starts the form in a position scrolled so that
the right hand edge shows:
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  ClientWidth := 300;
  with HorzScrollBar do
  begin
    { Set the range to twice the ClientWidth of the form }
    { This means that the forms logical size is twice as big }
    { as the physical window. }
    { Note that Range must always be larger than the ClientWidth }
    Range := 600; 
    Position := Range - ClientWidth; { start form out fully scrolled }
    Increment := 10;  { clicking the scroll arrows moves the form 10 pixels }
    Visible := True;  { Show the scrollbar }
  end;
end; 
// EndCode
// EndExample: ScrollBarIncrement
end.
